# Copyright 1999-2003 Gentoo Technologies, Inc.
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/net-mail/cyrus-imapd/cyrus-imapd-2.1.9.ebuild,v 1.11 2003/03/11 21:11:46 seemant Exp $

inherit perl-module

DESCRIPTION="The Cyrus IMAP Server"
HOMEPAGE="http://asg.web.cmu.edu/cyrus/imapd/"
SRC_URI="ftp://ftp.andrew.cmu.edu/pub/cyrus-mail/${P}.tar.gz"

LICENSE="as-is"
SLOT="0"
KEYWORDS="x86 -ppc -sparc "
IUSE="ssl kerberos perl snmp afs"

PROVIDE="virtual/imapd"
DEPEND="virtual/glibc
	afs? ( >=net-fs/openafs-1.2.2 )
	snmp? ( >=net-analyzer/ucd-snmp-4.2.3 )
	ssl? ( >=dev-libs/openssl-0.9.6 )
    	perl? ( >=dev-lang/perl-5.6.1 )
	kerberos? ( >=app-crypt/krb5-1.2.5 )
	>=sys-libs/db-3.2
	>=sys-libs/pam-0.75
	>=dev-libs/cyrus-sasl-2.1.2
	>=sys-apps/tcp-wrappers-7.6
	net-mail/mailbase"

# recommended: flex, maybe: net-snmp, postfix, perl?, afs, inn, tcl (cyradm)
	
pkg_setup() {
	if ! grep -q ^cyrus: /etc/passwd ; then
		useradd -c cyrus -d /usr/cyrus -g mail -s /bin/false -u 96 cyrus \
			|| die "problem adding user cyrus"
	fi
}

src_unpack() {
	unpack ${A}
	cd ${S}
	patch < ${FILESDIR}/config.diff || die "patch failed"
}

src_compile() {
	local myconf
	
	use afs && myconf="--with-afs" \
		|| myconf="--without-afs"

	use snmp && myconf="${myconf} --with-ucdsnmp=/usr" \
		|| myconf="${myconf} --without-ucdsnmp"

	use ssl && myconf="${myconf} --with-openssl=/usr" \
		|| myconf="${myconf} --without-openssl"

    	use perl && myconf="${myconf} --with-perl --enable-cyradm" \
		|| myconf="${myconf} --without-perl --disable-cyradm"

	use kerberos && myconf="${myconf} --with-krb --with-auth=krb" \
		|| myconf="${myconf} --without-krb --with-auth=unix"

	econf \
		--enable-listext \
		--with-cyrus-group=mail \
		--enable-netscapehack \
		--with-com_err=yes \
		${myconf}

	# make depends break with -f... in CFLAGS
	make depend CFLAGS="" || die "make depend problem"

	make || die "compile problem"
}

src_install() {
	# remove perl subdirs from beeing installed
	sed "s:SUBDIRS = imap sieve:SUBDIRS =:" ${S}/perl/Makefile > ${S}/perl/Makefile.install
	mv ${S}/perl/Makefile ${S}/perl/Makefile.orig
	mv ${S}/perl/Makefile.install ${S}/perl/Makefile

	# Install!
	make DESTDIR=${D} install || die

	# Fix manpage stuff
	rm -rf ${D}usr/man
	doman man/*.?

	dodir /etc
	cp ${FILESDIR}/imapd.conf ${D}etc/imapd.conf
	cp ${FILESDIR}/cyrus.conf ${D}etc/cyrus.conf
	dodir /etc/pam.d
	cp ${FILESDIR}/pam.d-imap ${D}etc/pam.d/imap

	dodir /var ${D}var/log
	touch ${D}var/log/imapd.log
	touch ${D}var/log/auth.log

   	mkdir -m 0750 ${D}var/imap
   	chown -R cyrus.mail ${D}var/imap 
   	mkdir -m 0755 ${D}var/imap/db
        chown -R cyrus.mail ${D}var/imap/db
   	mkdir -m 0755 ${D}var/imap/log
        chown -R cyrus.mail ${D}var/imap/log
   	mkdir -m 0755 ${D}var/imap/msg
        chown -R cyrus.mail ${D}var/imap/msg
   	mkdir -m 0755 ${D}var/imap/user
        chown -R cyrus.mail ${D}var/imap/user
	for i in a b c d e f g h i j k l m n o p q r s t u v w x y z ; do mkdir -m 0755 ${D}var/imap/user/$i ; \
	    chown -R cyrus.mail ${D}var/imap/user/$i ; done
   	mkdir -m 0755 ${D}var/imap/proc
        chown -R cyrus.mail ${D}var/imap/proc
   	mkdir -m 0755 ${D}var/imap/quota
	for i in a b c d e f g h i j k l m n o p q r s t u v w x y z ; do mkdir -m 0755 ${D}var/imap/quota/$i ; \
	    chown -R cyrus.mail ${D}var/imap/quota/$i ; done
	mkdir -m 0755 ${D}var/imap/sieve
        chown -R cyrus.mail ${D}var/imap/sieve
	for i in a b c d e f g h i j k l m n o p q r s t u v w x y z ; do mkdir -m 0755 ${D}var/imap/sieve/$i ; \
	    chown -R cyrus.mail ${D}var/imap/sieve/$i ; done
   	mkdir -m 0755 ${D}var/imap/socket
        chown -R cyrus.mail ${D}var/imap/socket

	dodir /var/spool
	mkdir -m 0750 ${D}var/spool/imap
        chown -R cyrus.mail ${D}var/spool/imap
	mkdir -m 0755 ${D}var/spool/imap/stage.
        chown -R cyrus.mail ${D}var/spool/imap/stage.
	# For hashimapspool
	for i in a b c d e f g h i j k l m n o p q r s t u v w x y z ; do mkdir -m 0755 ${D}var/spool/imap/$i ; \
	    chown -R cyrus.mail ${D}var/spool/imap/$i ; done


	dodoc COPYRIGHT README*
	dohtml doc/*.html doc/murder.png
	cp doc/cyrusv2.mc ${D}usr/share/doc/${PF}/html
	cp -r contrib tools ${D}usr/share/doc/${PF}

	# Remove the CVS directories
	find 2>/dev/null ${D}usr/share/doc/ -type d -name CVS -exec rm -rf '{}' \;

	exeinto /etc/init.d ; newexe ${FILESDIR}/cyrus.rc6 cyrus

	if use perl ; then
		export DESTDIR=${D}
		cd ${S}/perl/imap
		perl-module_src_prep
		perl-module_src_compile
		perl-module_src_test
		perl-module_src_install 
        cd ${S}/perl/sieve/acap
		perl-module_src_prep
		perl-module_src_compile
		perl-module_src_test
        perl-module_src_install
        cd ${S}/perl/sieve/acap/managesieve
		perl-module_src_prep
		perl-module_src_compile
		perl-module_src_test
        perl-module_src_install
	fi

	# remove empty log files installed by default
	rm ${D}/var/log/{auth,imapd}.log

}

pkg_postinst() {
	ewarn "If you change the fs-type of /var/imap or"
	ewarn "/var/spool/imap you should read step 9 of"
	ewarn "/usr/share/doc/${P}/html/install-configure.html."
	echo ""

	if df -T /var/imap | grep -q ' ext[23] ' ; then
		ewarn "Setting /var/imap/user/* and /var/imap/quota/* to synchronous"
		ewarn "updates."
		chattr +S /var/imap/user /var/imap/user/* /var/imap/quota /var/imap/quota/*
		echo ""
	fi

	if df -T /var/spool/imap | grep -q ' ext[23] ' ; then
		ewarn "Setting /var/spool/imap/* to synchronous updates."
		chattr +S /var/spool/imap /var/spool/imap/*
		echo ""
	fi

	ewarn "If the queue directory of the mail daemon resides on an ext2"
	ewarn "or ext3 partition you need to set it manually to update"
	ewarn "synchronously. E.g. 'chattr +S /var/spool/mqueue'."
	echo ""

	einfo "For correct logging add"
	einfo "\tlocal6.* /var/log/imapd.log"
	einfo "\tauth.debug /var/log/auth.log"
	einfo "to /etc/syslog.conf."
	echo ""

	if [ "'use ssl'" ]; then
		ewarn "Read the section about SSL and TLS of"
		ewarn "/usr/share/doc/${P}/html/install-configure.html."
		ewarn "about installing the needed keys."
	fi
}

