# Copyright 1999-2003 Gentoo Technologies, Inc.
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/app-text/dvipdfm/dvipdfm-0.13.2c.ebuild,v 1.9 2003/03/01 04:14:55 vapier Exp $

DESCRIPTION="DVI to PDF translator"
SRC_URI="http://gaspra.kettering.edu/dvipdfm/${P}.tar.gz"
HOMEPAGE="http://gaspra.kettering.edu/dvipdfm/"

KEYWORDS="x86 ppc sparc"
SLOT="0"
LICENSE="GPL-2"

DEPEND=">=app-text/tetex-1.0.7
	>=media-libs/libpng-1.2.1
	>=sys-libs/zlib-1.1.4"

S=${WORKDIR}/${PN}

src_compile() {
	econf || die
	emake || die
}

src_install () {
	einstall || die

	dodoc AUTHORS ChangeLog Credits INSTALL* NEWS OBTAINING README* TODO

	cp latex-support/dvipdfm.def ${D}/usr/share/doc/${P}/
	cp -a doc ${D}/usr/share/doc/${P}/manual
	cp -a latex-support ${D}/usr/share/doc/${P}
	dodoc ${FILESDIR}/README.Gentoo
}

pkg_postinst() {
	zcat /usr/share/doc/${P}/README.Gentoo.gz
}
