# Copyright 1999-2003 Gentoo Technologies, Inc.
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-util/bitkeeper/bitkeeper-3.0-r1.ebuild,v 1.5 2003/02/13 11:47:08 vapier Exp $

DESCRIPTION="BitKeeper is a scalable configuration management system."
SRC_URI=""
HOMEPAGE="http://www.bitkeeper.com"

SLOT="0"
LICENSE="BKL"
KEYWORDS="x86 ppc sparc alpha"

DEPEND=">=virtual/glibc-2.2
	>=dev-lang/tcl-8.3.3
	X? ( >=dev-lang/tk-8.3.3 )"

# I'm not sure what the official way to do this is...
use 'x86' >/dev/null && A="bk-3.0-x86-glibc22-linux.bin"
use 'ppc' >/dev/null && A="bk-3.0-powerpc-glibc21-linux.bin"
use 'sparc' >/dev/null && A="bk-3.0-sparc-glibc21-linux.bin"
use 'alpha' >/dev/null && A="bk-3.0-alpha-glibc21-linux.bin"

pkg_setup() {
	if [ ! -f ${DISTDIR}/${A} ] ; then
		eerror "You need to perform the following steps to install this package:"
		eerror "- Sign up at ${HOMEPAGE}"
		eerror "- Check your mail and visit the download location"
		eerror "- Download ${A} and place it in ${DISTDIR}"
		eerror "- emerge this package again"
		die "package must be downloaded"
	fi
}

src_unpack() {
	mkdir ${S}
	cp ${DISTDIR}/${A} ${S}/${A}
	chmod 755 ${S}/${A}
	echo 'none' | ${S}/${A} > ${S}/output 2>/dev/null
	installer=`sed -n -e "s/Installation script: \(.*\)/\1/p" ${S}/output`
	archive=`sed -n -e "s/Gzipped tar archive: \(.*\)/\1/p" ${S}/output`
	mv $installer ${S}/installer
	mv $archive ${S}/archive
}

src_install() {
	dodir /opt /etc/env.d
	cd ${D}/opt && tar -xzpf ${S}/archive
	mv ${D}/opt/bitkeeper ${D}/opt/${P}
	chown -R root:root ${D}/opt/${P}
	chmod -R u+w,go-w ${D}/opt/${P}
	cat <<EOF >${D}/etc/env.d/10bitkeeper
# Generated by ${P}.ebuild
PATH=/opt/${P}
ROOTPATH=/opt/${P}
MANPATH=/opt/${P}/man
EOF
}

pkg_postinst() {
	einfo "Run 'bk regressions' to verify the installation. (Recommended)"
}
